using System;

class Zadatak4 
{
    static (int[] x, int[] y, int br) konveksan(int[] a, int[] b, int n)
    {
        int[] sx = new int[n];
        int[] sy = new int[n];
        Array.Copy(a, sx, n);
        Array.Copy(b, sy, n);

        Array.Sort(sx, sy);

        int[] ox = new int[2 * n];
        int[] oy = new int[2 * n];
        int m = 0;

        for (int i = 0; i < n; i++) 
        {
            while (m >= 2 && Proizvod(ox[m - 2], oy[m - 2], ox[m - 1], oy[m - 1], sx[i], sy[i]) <= 0) 
            {
                m--;
            }

            ox[m] = sx[i];
            oy[m] = sy[i];
            m++;

        }

        int l = m + 1;

        for (int i = n - 1; i >= 0; i--)
        {
            while (m >= l && Proizvod(ox[m - 2], oy[m - 2], ox[m - 1], oy[m - 1], sx[i], sy[i]) <= 0)
            {
                m--;
            }
            ox[m] = sx[i];
            oy[m] = sy[i];
            m++;
        }

        return (ox, oy, m - 1);

    }

    static int skoroKonveksan(int[] a, int[] b, int n)
    {
        int minP = int.MaxValue;

        for (int i = 0; i < n; i++)
        {
            int[] sx = new int[n - 1];
            int[] sy = new int[n - 1];
            int l = 0;

            for (int j = 0; j < n; j++)
            {
                if (j != i)
                {
                    sx[l] = a[j];
                    sy[l] = b[j];
                    l++;
                }
            }

            var omotac = konveksan(sx, sy, n - 1);

            int p = povrsinaMnogougla(omotac.x, omotac.y, omotac.br);
            if (p < minP) minP = p;
        }

        return minP;
    }

    static int povrsinaMnogougla(int[] a, int[] b, int n) 
    {
        int p = 0;

        for(int i = 0; i < n; i++)
        {
            int x1 = a[i];
            int x2 = a[(i+1) % n];
            int y1 = b[i];
            int y2 = b[(i + 1) % n];
            p = p + x1 * y2 - x2 * y1;
        }

        p = Math.Abs(p) / 2;
        return p;
    }

    static int Proizvod(int x1, int y1, int x2, int y2, int x3, int y3)
    {
        return (x2 - x1) * (y3 - y1) - (y2 - y1) * (x3 - x1);
    }
    static void Main() 
    {
        int n = int.Parse(Console.ReadLine());
        int[] a = new int[n];
        int[] b = new int[n];

        for (int i = 0; i < n; i++)
        {
            string[] linija = Console.ReadLine().Split();
            a[i] = int.Parse(linija[0]);
            b[i] = int.Parse(linija[1]);
        }

        int r = skoroKonveksan(a, b, n);
        Console.WriteLine(r);
    }
}